<!DOCTYPE html>
<html lang="en">
    <head>
        <?php 
        session_start();
        $title = "Lock Screen";
        include 'partials/title-meta.php'; 
        include 'partials/head-css.php'; 
        ?>
    </head>

    <body class="loading authentication-bg authentication-bg-pattern">

        <div class="account-pages mt-5 mb-5">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-md-8 col-lg-6 col-xl-4">
                        <div class="text-center">
                            <a href="index.php">
                                <img src="assets/images/faida-logo.png" alt="" height="40" class="mx-auto">
                            </a>
                            <p class="text-muted mt-2 mb-4">Faida System</p>
                        </div>
                        <div class="card">

                            <div class="card-body p-4">
                                
                                <div class="text-center mb-4">
                                    <h4 class="text-uppercase mt-0 mb-4">Welcome Back</h4>
                                    <img src="assets/images/users/user-1.jpg" width="88" alt="user-image" class="rounded-circle img-thumbnail">
                                    <p><strong>Email: </strong> <?php echo $_SESSION['user_email']; ?></p> <!-- Display user's email -->
                        
                                    <?php if (isset($_SESSION['error'])): ?>
                                        <div class="error-message">
                                            <?php 
                                            echo $_SESSION['error'];
                                            unset($_SESSION['error']); 
                                            ?>
                                        </div>
                                    <?php endif; ?>

                                </div>

                                <form action="#">

                                    <div class="mb-3">
                                        <label for="password" class="form-label">Password</label>
                                        <input class="form-control" type="password" required="" id="password" placeholder="Enter your password">
                                    </div>

                                    <div class="mb-0 text-center d-grid">
                                        <button class="btn btn-primary" type="submit"> Log In </button>
                                    </div>

                                </form>
    
                            </div> <!-- end card-body -->
                        </div>
                        <!-- end card -->

                        <div class="row mt-3">
                            <div class="col-12 text-center">
                                <p class="text-muted">Not you? return <a href="auth-login.php" class="text-dark ms-1"><b>Sign In</b></a></p>
                            </div> <!-- end col -->
                        </div>
                        <!-- end row -->

                    </div> <!-- end col -->
                </div>
                <!-- end row -->
            </div>
            <!-- end container -->
        </div>
        <!-- end page -->
      
        <?php include 'partials/footer-scripts.php'; ?>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        
    </body>
</html>